// Ten program pokazuje sposób umieszczania obiektu
// plikowego w argumencie funkcji.
#include <iostream>
#include <fstream>
#include <string>
using namespace std;

// Prototypy funkcji
bool openFileIn(fstream &, string);
void showContents(fstream &);

int main()
{
  fstream dataFile;

  if (openFileIn(dataFile, "Demo.txt"))
  {
    cout << "Plik otwarty pomyślnie.\n";
    cout << "Odczytywanie danych z pliku.\n\n";
    showContents(dataFile);
    dataFile.close();
    cout << "\nKoniec.\n";
  }
  else
    cout << "Błąd otwarcia pliku!" << endl;

  return 0;
}

//************************************************************
// Definicja funkcji openFileIn(), której argumentem jest
// referencja obiektu typu fstream. Funkcja otwiera plik w
// trybie wejściowym. Jeżeli plik zostanie otwarty pomyślnie,
// funkcja zwraca wynik true, a w razie błędu zwraca wynik false.
//************************************************************

bool openFileIn(fstream &file, string name)
{
  file.open(name, ios::in);
  if (file.fail())
    return false;
  else
    return true;
}

//************************************************************
// Definicja funkcji showContents(), której argumentem jest
// referencja obiektu typu fstream. Funkcja wykorzystuje pętlę
// do odczytania imion z pliku i wyświetlenia ich na ekranie.
//************************************************************

void showContents(fstream &file)
{
  string line;

  while (file >> line)
  {
    cout << line << endl;
  }
}
